﻿using System;
using Microsoft.SharePoint;

namespace QueryList
{
   class Program
   {
      static void Main(string[] args)
      {
         using (SPSite site = new SPSite("http://contoso.de"))
         {
            using (SPWeb web = site.OpenWeb())
            {
               SPList listOrders = web.Lists.TryGetList("Bestellungen");

               SPQuery query = new SPQuery();

               query.Query = String.Concat(
                  "<OrderBy>",
                  " <FieldRef Name='Created' />",
                  "</OrderBy>",
                  "<Where>",
                  " <Geq>",
                  "  <FieldRef Name='Menge'/>",
                  "  <Value Type='Number'>1</Value>",
                  " </Geq>",
                  "</Where>");

               query.ViewFields = String.Concat(
                  "<FieldRef Name=\"Title\" Type=\"Text\"/>",
                  "<FieldRef Name=\"Modified\" Type=\"DateTime\"/>",
                  "<FieldRef Name=\"Kunde\" Type=\"Lookup\"/>",
                  "<FieldRef Name=\"Artikel\" Type=\"Lookup\"/>",
                  "<FieldRef Name=\"Menge\" Type=\"Number\"/>");

               // Definiere weitere Einstellungen der Anfrage
               query.ViewFieldsOnly = true;
               query.RowLimit = 500;

               // Hole die Liste der Elemente über die CAML-Abfrage
               SPListItemCollection myItems = listOrders.GetItems(query);

               foreach (SPListItem i in myItems)
               {
                  // Benutzerdefinierte Spalten auslesen
                  string articleRef = i["Artikel"] != null ?
                    i["Artikel"].ToString() : String.Empty;

                  string customerRef = i["Kunde"] != null ?
                     i["Artikel"].ToString() : String.Empty;

                  int amount = i["Menge"] != null ?
                     int.Parse(i["Menge"].ToString()) : 0;

                  // Erzeugung eines neuen SPFieldLookupValue-Objekts
                  SPFieldLookupValue article =
                     new SPFieldLookupValue(articleRef);
                  SPFieldLookupValue customer =
                     new SPFieldLookupValue(customerRef);

                  // Ausgabe der Daten
                  Console.WriteLine("Bestellung (Nummer {0})", i.Title);
                  Console.WriteLine("> Kunde: {0}", customer.LookupValue);
                  Console.WriteLine("> Artikel: {0}", article.LookupValue);
                  Console.WriteLine("> Anzahl: {0}\n", amount);
               }
            }
         }
      }
   }
}